import { Card ,CardHeader,CardTitle,CardDescription, CardContent } from "@/components/ui/card";
import { Button, buttonVariants } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Link } from "wouter";
import { ArrowLeft } from "lucide-react";

export default function Login() {
  return (
   <div className="relative flex min-h-svh flex-col items-center justify-center">

      <Link href="/" className={buttonVariants({
        variant: "outline",
        className: "absolute top-4 left-4 md:top-8 md:left-8"
      })}>
      <ArrowLeft className="size-4"/>
      Back
      </Link>
    <Card className="flex w-full max-w-xl flex-col ">
      <CardHeader>
        <CardTitle className="text-xl">Welcome Back!</CardTitle>
        <CardDescription>Login with your Email Account</CardDescription>
      </CardHeader>
      <CardContent>

         <Button 
         className="w-full mb-5" variant="outline">
          {/* <GoogleIcon></GoogleIcon> */}
         Continue with Google
         </Button>

         <div className="relative text-center tx-sm after:absolute after:inset-0 after:top-1/2 after:z-0 after:flex after:items-center after:border-t after:border-border mb-5">
          <span className="relative z-10 px-2 bg-card ">or Continue with</span>
         </div>
         
         <div className="grid gap-3">
            <div className="grid gap-2">
                 <label htmlFor="email">Email</label>
                 <Input type="email" placeholder="m@example.com"/>
            </div>
            <div className="grid gap-2">
                 <label htmlFor="password">Password</label>
                 <Input type="password" placeholder="••••••••"/>
            </div>
         </div>

        <Button className="w-full mt-5" variant="outline">
         Login</Button>
      </CardContent>
    </Card>
   </div>
  );
}